/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.IPAddress;
import apicore.message.IPV6Address;
import apicore.message.MACAddress;
import apicore.message.UUID;
import apicore.ptmp.EncodedBuffer;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtmpBuffer
implements EncodedBuffer {
    protected ByteBuffer buffer;
    protected boolean isTextMode = false;

    public PtmpBuffer(boolean bl) {
        this(600000, bl);
    }

    public PtmpBuffer(int n, boolean bl) {
        this.buffer = ByteBuffer.allocate(n);
        this.isTextMode = bl;
    }

    public boolean isTextMode() {
        return this.isTextMode;
    }

    @Override
    public EncodedBuffer duplicate() {
        PtmpBuffer ptmpBuffer = new PtmpBuffer(this.isTextMode);
        ptmpBuffer.buffer = this.buffer.duplicate();
        return ptmpBuffer;
    }

    public void dump(String string) {
        System.out.println(string + ".capacity = " + this.buffer.capacity());
        System.out.println(string + ".limit = " + this.buffer.limit());
        System.out.println(string + ".position = " + this.buffer.position());
        System.out.println(string + ".remaining = " + this.buffer.remaining());
    }

    @Override
    public byte[] copyRawBytes(boolean bl) {
        ByteBuffer byteBuffer = this.buffer.duplicate();
        byte[] byArray = new byte[byteBuffer.position()];
        if (bl) {
            byteBuffer.flip();
        }
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public byte[] getRawBytes() {
        byte[] byArray = null;
        if (this.buffer.limit() != this.buffer.capacity()) {
            this.buffer.compact();
        }
        byArray = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(byArray);
        this.buffer.clear();
        return byArray;
    }

    @Override
    public void setRawBytes(byte[] byArray) {
        this.buffer.clear();
        this.buffer.put(byArray);
        this.buffer.flip();
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public void rewind() {
        this.buffer.rewind();
    }

    @Override
    public void flip() {
        this.buffer.flip();
    }

    @Override
    public boolean getBool() {
        if (this.isTextMode()) {
            return this.asBool(this.nextString());
        }
        byte by = this.buffer.get();
        return by != 0;
    }

    @Override
    public byte getByte() {
        if (this.isTextMode()) {
            return this.asByte(this.nextString());
        }
        return this.buffer.get();
    }

    @Override
    public byte getByteRaw() {
        return this.buffer.get();
    }

    @Override
    public char getChar() {
        if (this.isTextMode()) {
            return this.asChar(this.nextString());
        }
        return this.buffer.getChar();
    }

    @Override
    public double getDouble() {
        if (this.isTextMode()) {
            return this.asDouble(this.nextString());
        }
        return this.buffer.getDouble();
    }

    @Override
    public float getFloat() {
        if (this.isTextMode()) {
            return this.asFloat(this.nextString());
        }
        return this.buffer.getFloat();
    }

    @Override
    public int getInt() {
        if (this.isTextMode()) {
            return this.asInt(this.nextString());
        }
        return this.buffer.getInt();
    }

    @Override
    public IPAddress getIPAddress() {
        if (this.isTextMode()) {
            return this.asIPAddress(this.nextString());
        }
        byte[] byArray = new byte[4];
        this.buffer.get(byArray, 0, 4);
        return new IPAddress(byArray);
    }

    @Override
    public IPV6Address getIPV6Address() {
        if (this.isTextMode()) {
            return this.asIPV6Address(this.nextString());
        }
        byte[] byArray = new byte[16];
        this.buffer.get(byArray, 0, 16);
        return new IPV6Address(byArray);
    }

    @Override
    public long getLong() {
        if (this.isTextMode()) {
            return this.asLong(this.nextString());
        }
        return this.buffer.getLong();
    }

    @Override
    public MACAddress getMACAddress() {
        if (this.isTextMode()) {
            return this.asMACAddress(this.nextString());
        }
        byte[] byArray = new byte[6];
        this.buffer.get(byArray, 0, 6);
        return new MACAddress(byArray);
    }

    @Override
    public short getShort() {
        if (this.isTextMode()) {
            return this.asShort(this.nextString());
        }
        return this.buffer.getShort();
    }

    @Override
    public String getString() {
        byte by;
        if (this.isTextMode()) {
            return this.nextString();
        }
        byte[] byArray = new byte[this.buffer.limit()];
        int n = 0;
        while (n < this.buffer.limit() && (by = this.buffer.get()) != 0) {
            byArray[n++] = by;
        }
        return new String(byArray, 0, n);
    }

    @Override
    public String peekString() {
        byte by;
        if (this.isTextMode()) {
            return this.peekNextString();
        }
        byte[] byArray = new byte[this.buffer.limit()];
        int n = 0;
        ByteBuffer byteBuffer = this.buffer.asReadOnlyBuffer();
        while (n < byteBuffer.limit() && (by = byteBuffer.get()) != 0) {
            byArray[n++] = by;
        }
        return new String(byArray, 0, n);
    }

    @Override
    public UUID getUUID() {
        if (this.isTextMode()) {
            return this.asUUID(this.nextString());
        }
        byte[] byArray = new byte[16];
        this.buffer.get(byArray, 0, 16);
        return new UUID(byArray);
    }

    @Override
    public EncodedBuffer putBool(boolean bl) {
        if (this.isTextMode()) {
            this.putString(this.asString(bl));
        } else {
            this.buffer.put((byte)(bl ? 1 : 0));
        }
        return this;
    }

    @Override
    public EncodedBuffer putByte(byte by) {
        if (this.isTextMode()) {
            this.putString(this.asString(by));
        } else {
            this.buffer.put(by);
        }
        return this;
    }

    @Override
    public EncodedBuffer putByteList(List<Byte> list) {
        this.putByte((byte)15);
        this.putByte((byte)1);
        this.putInt(list.size());
        for (Byte by : list) {
            this.buffer.put(by);
        }
        return this;
    }

    @Override
    public EncodedBuffer putChar(char c) {
        if (this.isTextMode()) {
            this.putString(this.asString(c));
        } else {
            this.buffer.putChar(c);
        }
        return this;
    }

    @Override
    public EncodedBuffer putDouble(double d) {
        if (this.isTextMode()) {
            this.putString(this.asString(d));
        } else {
            this.buffer.putDouble(d);
        }
        return this;
    }

    @Override
    public EncodedBuffer putFloat(float f) {
        if (this.isTextMode()) {
            this.putString(this.asString(f));
        } else {
            this.buffer.putFloat(f);
        }
        return this;
    }

    @Override
    public EncodedBuffer putInt(int n) {
        if (this.isTextMode()) {
            this.putString(this.asString(n));
        } else {
            this.buffer.putInt(n);
        }
        return this;
    }

    @Override
    public EncodedBuffer putIPAddress(IPAddress iPAddress) {
        if (this.isTextMode()) {
            this.putString(this.asString(iPAddress));
        } else {
            this.buffer.put(iPAddress.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putIPV6Address(IPV6Address iPV6Address) {
        if (this.isTextMode()) {
            this.putString(this.asString(iPV6Address));
        } else {
            this.buffer.put(iPV6Address.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putLong(long l) {
        if (this.isTextMode()) {
            this.putString(this.asString(l));
        } else {
            this.buffer.putLong(l);
        }
        return this;
    }

    @Override
    public EncodedBuffer putMACAddress(MACAddress mACAddress) {
        if (this.isTextMode()) {
            this.putString(this.asString(mACAddress));
        } else {
            this.buffer.put(mACAddress.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putShort(short s) {
        if (this.isTextMode()) {
            this.putString(this.asString(s));
        } else {
            this.buffer.putShort(s);
        }
        return this;
    }

    @Override
    public EncodedBuffer putString(String string) {
        if (this.isTextMode()) {
            for (int i = 0; i < string.length(); ++i) {
                this.buffer.put((byte)string.charAt(i));
            }
            this.buffer.put((byte)0);
        } else {
            this.buffer.put(string.getBytes());
            this.buffer.put((byte)0);
        }
        return this;
    }

    @Override
    public EncodedBuffer putStringAsBytes(byte[] byArray) {
        if (this.isTextMode()) {
            this.putString(this.asString(byArray));
        } else {
            this.buffer.put(byArray);
            this.buffer.put((byte)0);
        }
        return this;
    }

    @Override
    public EncodedBuffer putUUID(UUID uUID) {
        if (this.isTextMode()) {
            this.putString(this.asString(uUID));
        } else {
            this.buffer.put(uUID.getByteArrayValue());
        }
        return this;
    }

    protected String nextString() {
        byte[] byArray = new byte[this.buffer.limit()];
        int n = 0;
        while (n < this.buffer.limit()) {
            byte by = this.buffer.get();
            if (by != 0) {
                byArray[n++] = by;
                continue;
            }
            return new String(byArray, 0, n);
        }
        return new String(byArray, 0, n);
    }

    protected String peekNextString() {
        byte[] byArray = new byte[this.buffer.limit()];
        int n = 0;
        ByteBuffer byteBuffer = this.buffer.asReadOnlyBuffer();
        while (n < byteBuffer.limit()) {
            byte by = byteBuffer.get();
            if (by != 0) {
                byArray[n++] = by;
                continue;
            }
            return new String(byArray, 0, n);
        }
        return new String(byArray, 0, n);
    }

    protected boolean asBool(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    protected byte asByte(String string) {
        byte by = 0;
        try {
            by = Byte.parseByte(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return by;
    }

    protected char asChar(String string) {
        return string == null || string.length() == 0 ? (char)'\u0000' : string.charAt(0);
    }

    protected double asDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    protected float asFloat(String string) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    protected int asInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected IPAddress asIPAddress(String string) {
        IPAddress iPAddress = null;
        try {
            iPAddress = new IPAddress(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iPAddress;
    }

    protected IPV6Address asIPV6Address(String string) {
        IPV6Address iPV6Address = null;
        try {
            iPV6Address = new IPV6Address(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iPV6Address;
    }

    protected long asLong(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    protected MACAddress asMACAddress(String string) {
        MACAddress mACAddress = null;
        try {
            mACAddress = new MACAddress(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mACAddress;
    }

    protected short asShort(String string) {
        short s = 0;
        try {
            s = Short.parseShort(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    protected UUID asUUID(String string) {
        UUID uUID = null;
        try {
            uUID = new UUID(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uUID;
    }

    protected String asString(boolean bl) {
        return bl ? "true" : "false";
    }

    protected String asString(byte by) {
        return String.valueOf(by);
    }

    protected String asString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray);
    }

    protected String asString(char c) {
        return String.valueOf(c);
    }

    protected String asString(double d) {
        return String.valueOf(d);
    }

    protected String asString(float f) {
        return String.valueOf(f);
    }

    protected String asString(int n) {
        return String.valueOf(n);
    }

    protected String asString(IPAddress iPAddress) {
        return iPAddress.getDottedQuadString();
    }

    protected String asString(IPV6Address iPV6Address) {
        return iPV6Address.getColonHexString();
    }

    protected String asString(long l) {
        return String.valueOf(l);
    }

    protected String asString(MACAddress mACAddress) {
        return mACAddress.getDottedHexString();
    }

    protected String asString(short s) {
        return String.valueOf(s);
    }

    protected String asString(UUID uUID) {
        return uUID.getDecoratedHexString();
    }
}

